<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface SaveDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Save 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param save primary key
 	 */
	public function delete($saveid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Save save
 	 */
	public function insert($save, $savedetails);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Save save
 	 */
	public function update($save, $savedetails);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySavename($value);

	public function queryBySavecurrentvalue($value);

	public function queryBySavedetails($value);

	public function queryBySavedate($value);

	public function queryByConditions($value);

	public function queryByUserid($value);


	public function deleteBySavename($value);

	public function deleteBySavecurrentvalue($value);

	public function deleteBySavedetails($value);

	public function deleteBySavedate($value);

	public function deleteByConditions($value);

	public function deleteByUserid($value);


}
?>